/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ConvolveFilter;
import com.jhlabs.image.PixelUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;

public class GaussianFilter
extends ConvolveFilter {
    static final long serialVersionUID = 5377089073023183684L;
    private float radius;
    private Kernel kernel;
    private Kernel transposedKernel;

    public GaussianFilter() {
        this(2.0f);
    }

    public GaussianFilter(float radius) {
        this.setRadius(radius);
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.kernel = GaussianFilter.makeKernel(radius);
        this.transposedKernel = new Kernel(this.kernel.getHeight(), this.kernel.getWidth(), this.kernel.getKernelData(null));
    }

    public float getRadius() {
        return this.radius;
    }

    private void convolve(BufferedImage src, BufferedImage dst, Kernel kernel) {
        new ConvolveOp(kernel, 1, null).filter(src, dst);
    }

    public void filter(BufferedImage src) {
        ColorModel colorModel = src.getColorModel();
        int border = (int)Math.ceil(this.radius);
        int width = src.getWidth() + border * 2;
        int height = src.getHeight() + border * 2;
        WritableRaster raster = colorModel.createCompatibleWritableRaster(width, height);
        BufferedImage scaledSrc = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        Graphics graphics = scaledSrc.getGraphics();
        graphics.setColor(new Color(14804714));
        graphics.fillRect(0, 0, width, height);
        graphics.drawImage(src, border, border, null);
        BufferedImage dst = this.createCompatibleDestImage(scaledSrc, null);
        this.convolve(scaledSrc, dst, this.kernel);
        this.convolve(dst, scaledSrc, this.transposedKernel);
        src.getGraphics().drawImage(scaledSrc, -border, -border, null);
    }

    private static void convolveAndTranspose(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha, int edgeAction) {
        float[] kernelMatrix = kernel.getKernelData(null);
        int diameter = kernel.getWidth();
        int radius = diameter / 2;
        for (int pixelY = 0; pixelY < height; ++pixelY) {
            for (int pixelX = 0; pixelX < width; ++pixelX) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                float a = 0.0f;
                for (int dx = -radius; dx <= radius; ++dx) {
                    float f = kernelMatrix[radius + dx];
                    if (f == 0.0f) continue;
                    int x = pixelX + dx;
                    if (x < 0) {
                        if (edgeAction == CLAMP_EDGES) {
                            x = 0;
                        } else if (edgeAction == WRAP_EDGES) {
                            x = (pixelX + width) % width;
                        }
                    } else if (x >= width) {
                        if (edgeAction == CLAMP_EDGES) {
                            x = width - 1;
                        } else if (edgeAction == WRAP_EDGES) {
                            x = (pixelX + width) % width;
                        }
                    }
                    int rgb = inPixels[width * pixelY + x];
                    a += f * (float)(rgb >> 24 & 0xFF);
                    r += f * (float)(rgb >> 16 & 0xFF);
                    g += f * (float)(rgb >> 8 & 0xFF);
                    b += f * (float)(rgb & 0xFF);
                }
                int ia = alpha ? PixelUtils.clamp((int)((double)a + 0.5)) : 255;
                int ir = PixelUtils.clamp((int)((double)r + 0.5));
                int ig = PixelUtils.clamp((int)((double)g + 0.5));
                int ib = PixelUtils.clamp((int)((double)b + 0.5));
                outPixels[pixelX * height] = ia << 24 | ir << 16 | ig << 8 | ib;
            }
        }
    }

    private static Kernel makeKernel(float radius) {
        int r = (int)Math.ceil(radius);
        int rows = r * 2 + 1;
        float[] matrix = new float[rows];
        float sigma = radius / 3.0f;
        float sigma22 = 2.0f * sigma * sigma;
        float sigmaPi2 = (float)Math.PI * 2 * sigma;
        float sqrtSigmaPi2 = (float)Math.sqrt(sigmaPi2);
        float radius2 = radius * radius;
        float total = 0.0f;
        int index = 0;
        for (int row = -r; row <= r; ++row) {
            float distance = row * row;
            matrix[index] = distance > radius2 ? 0.0f : (float)Math.exp(-distance / sigma22) / sqrtSigmaPi2;
            total += matrix[index];
            ++index;
        }
        int i = 0;
        while (i < rows) {
            int n = i++;
            matrix[n] = matrix[n] / total;
        }
        return new Kernel(rows, 1, matrix);
    }

    @Override
    public String toString() {
        return "Blur/Gaussian Blur...";
    }
}

