/*
 * Decompiled with CFR 0.152.
 */
package com.juliand665;

import com.juliand665.Hexagon;
import com.juliand665.Options;
import com.juliand665.Panel3k;
import com.juliand665.Resources;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class MenuButton {
    private int posX;
    private int posY;
    private Rectangle bounds;
    private boolean isActive = false;

    public MenuButton(int x, int y) {
        this.setPos(x, y);
    }

    public void render(Graphics g) {
        Graphics2D gr = (Graphics2D)g.create();
        if (this.isActive) {
            gr.setComposite(AlphaComposite.getInstance(3, 0.8f));
        }
        gr.drawImage(Resources.menuButtons[(Panel3k.highestTile[Options.difficulty][1] % 10 + Hexagon.baseToOffset.get(Panel3k.highestTile[Options.difficulty][0])) % 36], this.posX, this.posY, null);
    }

    public void mouseMoved(int x, int y) {
        this.isActive = this.bounds.contains(x, y);
    }

    public void mouseClicked() {
        if (this.isActive && (this.posX > 0 || this.posY > 0)) {
            Panel3k.pauseGame();
            if (Panel3k.inTutorial) {
                Panel3k.inTutorial = false;
            }
        }
    }

    public void setPos(int x, int y) {
        this.posX = x;
        this.posY = y;
        this.bounds = new Rectangle(x, y, 128, 64);
    }
}

