/*
 * Decompiled with CFR 0.152.
 */
package com.juliand665;

import com.juliand665.Field;
import com.juliand665.InputManager;
import com.juliand665.Instructions;
import com.juliand665.LoggingLevel;
import com.juliand665.MenuButton;
import com.juliand665.Options;
import com.juliand665.ParticleManager;
import com.juliand665.Popups;
import com.juliand665.Renderer;
import com.juliand665.Resources;
import com.juliand665.Screen;
import com.juliand665.Splash;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Panel3k
extends JPanel {
    private static final long serialVersionUID = 4983727800375272097L;
    public static JFrame frame;
    public static Panel3k instance;
    public static Resources resources;
    public static Splash splash;
    public static Options options;
    public static Instructions instructions;
    public static Renderer renderer;
    public static Field field;
    public static InputManager inputManager;
    public static MenuButton menuButton;
    public static Popups popups;
    public static ParticleManager particleManager;
    public static final int SIZE_X = 1136;
    public static final int SIZE_Y = 640;
    public static final Dimension DIMENSION;
    public static final LoggingLevel loggingLevel;
    public static int[][] highestTile;
    public static long[] highestScore;
    public static Screen currentScreen;
    public static boolean inTutorial;
    public static int[] activePowerups;
    private File saveFile;
    private RandomAccessFile rAccess;
    private boolean doesSaveFileExist;
    private BufferedReader reader;
    private PrintWriter writer;

    public Panel3k() {
        this.setFocusable(true);
        instance = this;
        resources = new Resources();
        field = new Field();
        splash = new Splash();
        popups = new Popups();
        options = new Options();
        renderer = new Renderer();
        instructions = new Instructions();
        inputManager = new InputManager();
        particleManager = new ParticleManager();
        this.init();
        this.setSize(DIMENSION);
        this.setPreferredSize(DIMENSION);
        frame = new JFrame("3k");
        frame.setContentPane(this);
        frame.pack();
        frame.setResizable(false);
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        this.addKeyListener(inputManager);
        this.addMouseListener(inputManager);
        this.addMouseMotionListener(inputManager);
    }

    public static void main(String[] args) {
        instance = new Panel3k();
    }

    public void init() {
        try {
            Panel3k.log("[SAVE] Save file is at " + new File("saveFile.3ksave").getAbsolutePath());
            this.saveFile = new File("saveFile.3ksave");
            this.rAccess = new RandomAccessFile(this.saveFile, "rwd");
            this.doesSaveFileExist = !this.saveFile.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        menuButton = new MenuButton(80, 288);
        splash.switchTo();
        resources.init();
        renderer.init();
        field.init();
        this.readSaveFile();
    }

    public static void log(Object o) {
        Panel3k.log(LoggingLevel.FINE, o);
    }

    public static void log(LoggingLevel level, Object o) {
        if (level == LoggingLevel.ERROR) {
            System.out.println("3k has encountered an error! " + o.toString());
            return;
        }
        if (loggingLevel != LoggingLevel.OFF) {
            if (loggingLevel == LoggingLevel.FINE) {
                System.out.println("3k logs: " + o.toString());
            } else if (level == LoggingLevel.ROUGH) {
                System.out.println("3k logs: " + o.toString());
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        renderer.render(g);
        this.repaint();
    }

    public static void pauseGame() {
        Panel3k.log("Game paused!");
        currentScreen = Screen.PAUSE_MENU;
    }

    public static void unpauseGame() {
        Panel3k.log("Game unpaused!");
        inTutorial = false;
        renderer.unpause();
        currentScreen = Screen.GAME;
        menuButton.setPos(80, 288);
    }

    public void pauseButtonPressed(int button) {
        if (button == 0) {
            Panel3k.unpauseGame();
            field.reset();
            instance.writeSaveFile();
        }
        if (button == 1) {
            Panel3k.unpauseGame();
        }
        if (button == 5) {
            options.switchTo();
        }
        if (button == 4) {
            instructions.switchTo();
        }
        if (button == 3) {
            menuButton.setPos(504, 183);
            currentScreen = Screen.CREDITS;
        }
        if (button == 2) {
            menuButton.setPos(632, 461);
            currentScreen = Screen.IPHONE;
        }
    }

    public void readSaveFile() {
        Panel3k.log("[SAVE] Attempting to read save file!");
        if (this.saveFile != null) {
            try {
                this.reader = new BufferedReader(new FileReader(this.saveFile));
                String s = this.reader.readLine();
                if (s == null || s.length() == 0) {
                    Panel3k.log("[SAVE] Save file empty! not reading that.");
                    return;
                }
                String[] data = s.split("/", 0);
                Panel3k.log("[SAVE] Dumping save file data: ");
                for (String d : data) {
                    Panel3k.log("[SAVE] " + d);
                }
                if (data.length > 22) {
                    int i;
                    Panel3k.log("[SAVE] Save file compatible! reading...");
                    for (i = 0; i < 4; ++i) {
                        Panel3k.highestScore[i] = Long.parseLong(data[i + 1]);
                    }
                    for (i = 0; i < 4; ++i) {
                        for (int j = 0; j < 2; ++j) {
                            Panel3k.highestTile[i][j] = Integer.parseInt(data[5 + 2 * i + j]);
                        }
                    }
                    Options.difficulty = Integer.parseInt(data[13]);
                    Options.controlByArrowKeys = Boolean.parseBoolean(data[14]);
                    Options.controlByDrag = Boolean.parseBoolean(data[15]);
                    Options.controlByLetterKeys = Boolean.parseBoolean(data[16]);
                    Options.quickReset = Boolean.parseBoolean(data[17]);
                    Options.flashHexes = Boolean.parseBoolean(data[18]);
                    inTutorial = Boolean.parseBoolean(data[19]);
                    if (!inTutorial) {
                        Panel3k.unpauseGame();
                    }
                    for (i = 0; i < 3; ++i) {
                        Panel3k.activePowerups[i] = Integer.parseInt(data[20 + i]);
                    }
                } else {
                    Panel3k.log("[SAVE] Something's wrong with the save file! couldn't read D:");
                }
                s = this.reader.readLine();
                if (s == null || s.length() == 0) {
                    field.reset();
                    Panel3k.log("[SAVE] No saved field to read");
                } else {
                    field.readSaveFile(s);
                }
                s = this.reader.readLine();
                if (s == null || s.length() == 0) {
                    Panel3k.log("[SAVE] No saved popup data to read");
                } else {
                    popups.readSaveFile(s);
                }
                Panel3k.log("[SAVE] Done reading save file! :D");
                this.reader.close();
            }
            catch (IOException e) {
                Panel3k.log("[SAVE] Error reading save file!");
                e.printStackTrace();
            }
        } else {
            Panel3k.log("[SAVE] Couldn't read save file, because there is no save file!");
        }
    }

    public void writeSaveFile() {
        try {
            int i;
            if (this.writer == null) {
                this.writer = new PrintWriter(this.saveFile);
            }
            Panel3k.log("[SAVE] Writing save file!");
            String s = "";
            for (i = 0; i < 4; ++i) {
                s = s + "/" + highestScore[i];
            }
            for (i = 0; i < 4; ++i) {
                for (int j = 0; j < 2; ++j) {
                    s = s + "/" + highestTile[i][j];
                }
            }
            s = s + "/" + Options.difficulty;
            s = s + "/" + Options.controlByArrowKeys;
            s = s + "/" + Options.controlByDrag;
            s = s + "/" + Options.controlByLetterKeys;
            s = s + "/" + Options.quickReset;
            s = s + "/" + Options.flashHexes;
            s = s + "/" + inTutorial;
            for (i = 0; i < 3; ++i) {
                s = s + "/" + activePowerups[i];
            }
            this.rAccess.setLength(0L);
            Panel3k.log("[SAVE] " + s);
            this.writer.println(s);
            field.writeSaveFile(this.writer);
            popups.writeSaveFile(this.writer);
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        DIMENSION = new Dimension(1136, 640);
        loggingLevel = LoggingLevel.ROUGH;
        highestTile = new int[][]{{3, 0}, {2, 0}, {2, 0}, {2, 0}};
        highestScore = new long[]{0L, 0L, 0L, 0L};
        inTutorial = true;
        activePowerups = new int[]{-1, -1, -1};
    }
}

