/*
 * Decompiled with CFR 0.152.
 */
package com.juliand665;

import com.jhlabs.image.GaussianFilter;
import com.juliand665.Field;
import com.juliand665.HexPowerup;
import com.juliand665.Hexagon;
import com.juliand665.InputManager;
import com.juliand665.LoggingLevel;
import com.juliand665.Options;
import com.juliand665.Panel3k;
import com.juliand665.Resources;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class Renderer {
    private Image dbImage;
    private Graphics dbg;
    private Panel3k panel;
    private BufferedImage blurredBg;
    private long lastFrame = System.currentTimeMillis();
    private int fps_time = 60;
    private int fps = 0;
    public static final int[][] pauseButtonPosData = new int[][]{{512, 0, 368, 224, 384, 0}, {880, 0, 512, 320, 624, 0}, {880, 324, 512, 320, 624, 320}, {512, 420, 368, 224, 384, 416}, {0, 324, 512, 320, 0, 320}, {0, 0, 512, 320, 0, 0}};
    public static final String[] pauseButtonText = new String[]{"Restart", "Continue", "Get iPhone Version", "Credits", "Instructions", "Options"};

    public void init() {
        this.panel = Panel3k.instance;
    }

    public void render(Graphics g) {
        if (this.dbImage == null) {
            this.dbImage = this.panel.createImage(1136, 640);
            this.dbg = this.dbImage.getGraphics();
        }
        this.dbg.setColor(new Color(0xCCCCCC));
        this.dbg.fillRect(0, 0, 1136, 640);
        try {
            Graphics2D gr = (Graphics2D)this.dbg.create();
            gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gr.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            switch (Panel3k.currentScreen) {
                case GAME: {
                    this.renderGame(gr);
                    break;
                }
                case PAUSE_MENU: {
                    if (this.blurredBg == null) {
                        BufferedImage bimg = (BufferedImage)this.panel.createImage(1136, 640);
                        this.renderGame((Graphics2D)bimg.getGraphics());
                        new GaussianFilter(50.0f).filter(bimg);
                        this.blurredBg = bimg;
                    }
                    this.renderPausedGame(gr);
                    break;
                }
                case OPTIONS: {
                    Panel3k.options.render(gr);
                    break;
                }
                case INSTRUCTIONS: {
                    Panel3k.instructions.render(gr);
                    break;
                }
                case SPLASH: {
                    Panel3k.splash.render(gr);
                    break;
                }
                case CREDITS: {
                    this.renderCredits(gr);
                    break;
                }
                case IPHONE: {
                    this.renderiPhoneVersion(gr);
                    break;
                }
            }
            gr.dispose();
            this.fps_time = (int)((float)this.fps_time * 0.9f + (float)(System.currentTimeMillis() - this.lastFrame) * 0.1f);
            this.fps = 1000 / this.fps_time;
            this.lastFrame = System.currentTimeMillis();
            boolean showFPS = false;
            if (showFPS) {
                this.dbg.setFont(Resources.baseFont.deriveFont(20.0f));
                this.dbg.setColor(Color.RED);
                this.dbg.drawString(this.fps + " FPS", 2, 21);
            }
        }
        catch (Exception e) {
            Panel3k.log(LoggingLevel.ERROR, "------------------------------ RENDER ERROR!");
            e.printStackTrace();
        }
        g.drawImage(this.dbImage, 0, 0, null);
    }

    private void renderiPhoneVersion(Graphics2D g) {
        g.drawImage(Resources.iPhoneBg, 0, 0, null);
        Panel3k.menuButton.render(g);
        int base = Panel3k.highestTile[Options.difficulty][0];
        int exponent = Panel3k.highestTile[Options.difficulty][1];
        g.setFont(Resources.baseFont.deriveFont(80.0f));
        g.setColor(Color.WHITE);
        g.drawImage(Resources.largeHexes[exponent % 10 + Hexagon.baseToOffset.get(base)], 280, 308, null);
        if (exponent >= 10 && exponent < 40) {
            g.drawImage(Resources.overlaysLarge[exponent / 10 - 1], 280, 308, null);
        }
        String s = Hexagon.getDisplayedString(base, exponent);
        this.drawStringCentered(g, s, 408, 436);
        int fontSize = 60;
        String score = "" + Field.score;
        while (g.getFontMetrics(Resources.baseFont.deriveFont((float)fontSize * 1.0f)).getStringBounds(score, g).getWidth() > 280.0) {
            --fontSize;
        }
        g.setFont(Resources.baseFont.deriveFont((float)fontSize * 1.0f));
        this.drawStringCentered(g, score, 696, 380);
        g.setColor(new Color(6816025));
        g.setFont(Resources.baseFont.deriveFont(24.0f));
        this.drawStringCentered(g, "Max: " + Panel3k.highestScore[Options.difficulty], 696, 420);
    }

    private void renderCredits(Graphics2D g) {
        g.drawImage(Resources.creditsBg, 0, 0, null);
        Panel3k.menuButton.render(g);
    }

    private void renderGame(Graphics2D g) throws Exception {
        g.drawImage(Resources.backgroundWide, 0, 0, null);
        g.setColor(new Color(0xFFFFFF));
        g.setFont(Resources.baseFont);
        Panel3k.field.render(g);
        int[] active = Panel3k.activePowerups;
        for (int i = 0; i < 3; ++i) {
            if (active[i] <= 0) continue;
            g.drawImage(Resources.powerups[i], 896, 32 + i * 192, null);
            g.drawString(active[i] + "x", 942, 208 + i * 192);
        }
        Panel3k.menuButton.render(g);
        g.setColor(new Color(0xFFFFFF));
        int base = Panel3k.highestTile[Options.difficulty][0];
        int exponent = Panel3k.highestTile[Options.difficulty][1];
        g.setFont(Resources.baseFont.deriveFont(80.0f));
        g.drawImage(Resources.largeHexes[(exponent % 10 + Hexagon.baseToOffset.get(base)) % 36], 16, 0, null);
        if (exponent >= 10 && exponent < 60) {
            g.drawImage(Resources.overlaysLarge[(exponent > 39 ? 39 : exponent) / 10 - 1], 16, 0, null);
        }
        String s = Hexagon.getDisplayedString(base, exponent);
        this.drawStringCentered(g, s, 144, 128);
        int fontSize = 60;
        String score = "" + Field.score;
        while (g.getFontMetrics(Resources.baseFont.deriveFont((float)fontSize * 1.0f)).getStringBounds(score, g).getWidth() > 220.0) {
            --fontSize;
        }
        g.setFont(Resources.baseFont.deriveFont((float)fontSize * 1.0f));
        this.drawStringCentered(g, score, 160, 544);
        g.setColor(new Color(6816025));
        fontSize = 24;
        score = "Max: " + Panel3k.highestScore[Options.difficulty];
        while (g.getFontMetrics(Resources.baseFont.deriveFont((float)fontSize * 1.0f)).getStringBounds(score, g).getWidth() > 200.0) {
            --fontSize;
        }
        g.setFont(Resources.baseFont.deriveFont((float)fontSize * 1.0f));
        this.drawStringCentered(g, score, 160, 584);
        Panel3k.particleManager.render(g);
        if (HexPowerup.descToRender > -1) {
            g.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g.setColor(new Color(14804714));
            g.fillRect(0, 0, 1136, 640);
            g.setComposite(AlphaComposite.getInstance(3));
            g.drawImage(Resources.powerupDescs[HexPowerup.descToRender], 184, 488, null);
        }
        Panel3k.popups.render(g);
        if (InputManager.dragDuration > -1) {
            ++InputManager.dragDuration;
        }
        if (InputManager.dragDuration > 20) {
            g.drawImage(Resources.moveSymbols[InputManager.dir + 1], InputManager.startX - 64, InputManager.startY - 64, null);
        }
    }

    private void renderPausedGame(Graphics2D g) {
        g.drawImage((Image)this.blurredBg, 0, 0, null);
        g.setFont(Resources.baseFont);
        for (int i = 0; i < 6; ++i) {
            this.drawButtonWithID((Graphics2D)g.create(), i);
        }
        g.setColor(Color.WHITE);
        this.drawButton(g, Resources.pauseButtons, 584, 224, 224, 196, 456, 222, "");
    }

    private void drawButtonWithID(Graphics2D g, int id) {
        Image img = Resources.pauseButtons;
        int dir = Panel3k.inputManager.mouseDirFromCenter(112);
        if (dir == id) {
            g.setComposite(AlphaComposite.getInstance(9));
            g.setColor(Color.BLACK);
        } else {
            g.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g.setColor(Color.WHITE);
        }
        this.drawButton(g, img, pauseButtonPosData[id][0], pauseButtonPosData[id][1], pauseButtonPosData[id][2], pauseButtonPosData[id][3], pauseButtonPosData[id][4], pauseButtonPosData[id][5], pauseButtonText[id]);
        g.dispose();
    }

    public void drawButton(Graphics2D g, Image img, int sx, int sy, int w, int h, int dx, int dy, String text) {
        g.drawImage(img, dx, dy, dx + w, dy + h, sx, sy, sx + w, sy + h, null);
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        this.drawStringCentered(g, text, dx + w / 2, dy + h / 2);
    }

    public void drawStringCentered(Graphics g, String s, int x, int y) {
        FontMetrics fm = g.getFontMetrics();
        int width = (int)fm.getStringBounds(s, 0, s.length(), g).getWidth();
        int height = fm.getHeight() * 6 / 10;
        g.drawString(s, x - width / 2, y + height / 2);
    }

    public void unpause() {
        this.blurredBg = null;
    }

    public int getSPF() {
        return this.fps_time;
    }
}

