/*
 * Decompiled with CFR 0.152.
 */
package com.juliand665;

import com.juliand665.LoggingLevel;
import com.juliand665.Panel3k;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class Resources {
    public static Image backgroundWide;
    public static Image pauseButtons;
    public static Image optionsBg;
    public static Image creditsBg;
    public static Image iPhoneBg;
    public static Image splashBg;
    public static Image blockade;
    public static Image[] largeHexes;
    public static Image[] smallHexes;
    public static Image[] menuButtons;
    public static Image[] powerups;
    public static Image[] powerupTiles;
    public static Image[] powerupDescs;
    public static Image[] instructionsBg;
    public static Image[] particles;
    public static Image[] buttons;
    public static Image[] popups;
    public static Image[] overlays;
    public static Image[] overlaysLarge;
    public static Image[] moveSymbols;
    public static Font baseFont;

    public void init() {
        Panel3k.log("Initializing Art!");
        try {
            this.loadImages();
            URL url = Resources.GetUrl("oswald/Oswald-Regular.ttf");
            InputStream stream = url.openStream();
            baseFont = Font.createFont(0, stream).deriveFont(40.0f);
        }
        catch (IOException e) {
            Panel3k.log(LoggingLevel.ERROR, "I/O Error occurred while loading art!");
            e.printStackTrace();
        }
        catch (FontFormatException e) {
            Panel3k.log(LoggingLevel.ERROR, "Font Format Error occurred while loading art!");
            e.printStackTrace();
        }
        Panel3k.log(Resources.class.getResource(""));
    }

    public void loadImages() throws IOException {
        try {
            for (int i = 0; i < 4; ++i) {
                Resources.instructionsBg[i] = ImageIO.read(Resources.GetUrl("Instruction" + (i + 1) + ".png"));
            }
            backgroundWide = ImageIO.read(Resources.GetUrl("Bg_Desktop.png"));
            pauseButtons = ImageIO.read(Resources.GetUrl("Pause_Buttons.png"));
            splashBg = ImageIO.read(Resources.GetUrl("Bg_Desktop_Splash.png"));
            iPhoneBg = ImageIO.read(Resources.GetUrl("Bg_Desktop_iPhone.png"));
            optionsBg = ImageIO.read(Resources.GetUrl("Bg_Desktop_Options.png"));
            creditsBg = ImageIO.read(Resources.GetUrl("Bg_Desktop_Credits.png"));
            blockade = ImageIO.read(Resources.GetUrl("Hexagons_Special.png")).getSubimage(128, 1536, 128, 128);
            Resources.buttons[0] = ImageIO.read(Resources.GetUrl("Interface_Buttons.png")).getSubimage(0, 0, 256, 640);
            Resources.buttons[1] = ImageIO.read(Resources.GetUrl("Interface_Buttons.png")).getSubimage(336, 0, 256, 640);
            popups = this.getSprites("Interface_Buttons.png", 592, 112, 0, 640, 1, 3);
            largeHexes = this.getSprites("Hexagons.png", 256, 256, 0, 0, 1, 36);
            smallHexes = this.getSprites("Hexagons.png", 128, 128, 256, 0, 1, 36);
            menuButtons = this.getSprites("Hexagons.png", 128, 64, 384, 0, 1, 36);
            powerups = this.getSprites("Hexagons_Special.png", 192, 192, 0, 0, 1, 8);
            powerupTiles = this.getSprites("Hexagons_Special.png", 128, 128, 192, 0, 1, 8, 0, 64);
            powerupDescs = this.getSprites("Powerup_Descs.png", 768, 112, 0, 0, 1, 8);
            overlays = this.getSprites("Hexagons_Special.png", 128, 128, 0, 1536, 1, 3);
            overlaysLarge = this.getSprites("Hexagons_Special.png", 256, 256, 0, 1920, 1, 3);
            moveSymbols = this.getSprites("Move_Symbols.png", 128, 128, 0, 0, 1, 7);
            Resources.particles[0] = ImageIO.read(Resources.GetUrl("Hexagons_Special.png")).getSubimage(256, 1664, 64, 64);
            Resources.particles[1] = ImageIO.read(Resources.GetUrl("Hexagons_Special.png")).getSubimage(128, 1664, 128, 128);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to load image files, e.g. \"Bg_Desktop.png\" at " + Resources.GetUrl("Bg_Desktop.png"));
        }
    }

    public static URL GetUrl(String s) {
        return Resources.class.getResource("res/" + s);
    }

    public BufferedImage[] getSprites(String name, int width, int height, int xOffset, int yOffset, int cols, int rows) {
        return this.getSprites(name, width, height, xOffset, yOffset, cols, rows, 0, 0);
    }

    public BufferedImage[] getSprites(String name, int width, int height, int xOffset, int yOffset, int cols, int rows, int xDist, int yDist) {
        BufferedImage img;
        try {
            img = ImageIO.read(Resources.GetUrl(name));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load image file \"" + name + "\" at " + Resources.GetUrl(name));
        }
        BufferedImage[] sprites = new BufferedImage[cols * rows];
        for (int i1 = 0; i1 < rows; ++i1) {
            for (int j1 = 0; j1 < cols; ++j1) {
                sprites[i1 * cols + j1] = img.getSubimage(xOffset + j1 * (width + xDist), yOffset + i1 * (height + yDist), width, height);
            }
        }
        return sprites;
    }

    static {
        instructionsBg = new Image[4];
        particles = new Image[2];
        buttons = new Image[2];
    }
}

