/*
 * Decompiled with CFR 0.152.
 */
package com.juliand665;

import com.juliand665.HexBlockade;
import com.juliand665.HexPowerup;
import com.juliand665.HexSpecial;
import com.juliand665.Hexagon;
import com.juliand665.LoggingLevel;
import com.juliand665.Options;
import com.juliand665.Panel3k;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;

public class Field {
    public static Hexagon[][] field;
    public static Hexagon[][] nextField;
    public Random random;
    public static final float[] OFFSET;
    public static final int[] MAX;
    public static final int[] BASES;
    public static final int TIMES_TO_MOVE = 4;
    public static final int MAX_TICK = 50;
    public static float moveTick;
    public static int currentDir;
    public static int moveTimes;
    public static long score;
    public static long moveNumber;

    public void init() {
        this.random = new Random(System.nanoTime());
        this.reset();
    }

    public void updateScore() {
        long s = 0L;
        for (int i = 0; i < 5; ++i) {
            for (Hexagon h : field[i]) {
                if (h == null || !(h.getNumber() > 0.0)) continue;
                s = (long)((double)s + (double)h.getBase() * Math.pow(3.0, h.getExponent()));
            }
        }
        score = s;
        if (score > Panel3k.highestScore[Options.difficulty]) {
            Panel3k.highestScore[Options.difficulty] = score;
        }
    }

    public void render(Graphics g) {
        if (moveTick > 0.0f && (moveTick -= (float)Panel3k.renderer.getSPF()) <= 0.0f) {
            this.exchangeFields();
            this.moveHexes(currentDir);
            if (--moveTimes > 0) {
                moveTick = 50.0f;
            } else {
                this.finishedMoving();
            }
        }
        for (int i = 0; i < 5; ++i) {
            for (Hexagon h : field[i]) {
                if (h == null) continue;
                h.render(g);
            }
        }
    }

    public void exchangeFields() {
        field = nextField;
        this.updateScore();
    }

    public void move(int dir) {
        if (currentDir > -1 || dir == -1) {
            return;
        }
        currentDir = dir;
        moveTimes = 4;
        moveTick = 50.0f;
        this.moveHexes(dir);
    }

    public void moveHexes(int dir) {
        nextField = new Hexagon[5][5];
        if (dir == 1 || dir == 2) {
            for (int i = 4; i > -1; --i) {
                Hexagon h;
                int j;
                if (dir == 1) {
                    for (j = 0; j < 5; ++j) {
                        h = field[i][j];
                        if (h == null) continue;
                        h.move(dir);
                    }
                    continue;
                }
                for (j = 4; j > -1; --j) {
                    h = field[i][j];
                    if (h == null) continue;
                    h.move(dir);
                }
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                Hexagon h;
                int j;
                if (dir == 3 || dir == 4) {
                    for (j = 4; j > -1; --j) {
                        h = field[i][j];
                        if (h == null) continue;
                        h.move(dir);
                    }
                    continue;
                }
                for (j = 0; j < 5; ++j) {
                    h = field[i][j];
                    if (h == null) continue;
                    h.move(dir);
                }
            }
        }
    }

    public void finishedMoving() {
        Panel3k.log("Finished moving!");
        if (this.hasAnythingMoved()) {
            this.addRandomHex();
            if (Panel3k.activePowerups[0] > 0) {
                Panel3k.activePowerups[0] = Panel3k.activePowerups[0] - 1;
            }
            if (Panel3k.activePowerups[2] > 0 && Panel3k.activePowerups[1] == 0) {
                Panel3k.activePowerups[2] = Panel3k.activePowerups[2] - 1;
            }
            if (Panel3k.activePowerups[1] > 0) {
                Panel3k.activePowerups[1] = Panel3k.activePowerups[1] - 1;
            }
        }
        if (++moveNumber == 100L && Options.difficulty == 0) {
            Panel3k.popups.popup(1);
        }
        for (int i = 0; i < 5; ++i) {
            for (Hexagon h : field[i]) {
                if (h == null) continue;
                h.doneMoving();
            }
        }
        currentDir = -1;
        Panel3k.instance.writeSaveFile();
        if (!this.canMakeAnotherMove()) {
            Panel3k.popups.popup(2);
        }
    }

    public boolean hasAnythingMoved() {
        for (int i = 0; i < 5; ++i) {
            for (Hexagon h : field[i]) {
                if (h == null || !h.hasMoved) continue;
                return true;
            }
        }
        return false;
    }

    public void addRandomHex() {
        boolean flag = false;
        while (!flag) {
            Hexagon hex;
            int j;
            int i = this.random.nextInt(5);
            if (field[i][j = this.random.nextInt(MAX[i])] != null) continue;
            if (this.random.nextInt(32) == 0) {
                hex = this.createRandomPowerup(i, j);
            } else {
                if (Panel3k.activePowerups[1] > 0) {
                    return;
                }
                hex = Panel3k.activePowerups[2] > 0 ? new Hexagon(i, j, BASES[this.random.nextInt(Options.difficulty + 1)], 2) : new Hexagon(i, j, BASES[this.random.nextInt(Options.difficulty + 1)], this.random.nextInt(2));
            }
            hex.flash = 128.0f;
            Field.field[i][j] = hex;
            flag = true;
        }
    }

    public void delegateMouseToPowerups(MouseEvent e) {
        for (int i = 0; i < 5; ++i) {
            for (Hexagon h : field[i]) {
                if (h == null || !(h instanceof HexPowerup)) continue;
                ((HexPowerup)h).mouseMoved(e);
            }
        }
    }

    public HexPowerup createRandomPowerup(int i, int j) {
        int type = this.random.nextInt(Options.difficulty == 0 ? 7 : 8);
        HexPowerup hex = new HexPowerup(i, j, type, 0);
        if (type < 3) {
            hex.setDuration(this.random.nextInt(5) + 1);
        }
        if (type == 6) {
            hex.setDuration(this.random.nextInt(2) + 1);
        }
        Panel3k.popups.popup(0);
        return hex;
    }

    public void reset() {
        int i;
        Panel3k.log(LoggingLevel.ROUGH, "Resetting Field!");
        field = new Hexagon[5][5];
        for (i = 0; i < 3; ++i) {
            Panel3k.activePowerups[i] = 0;
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < MAX[i]; ++j) {
                if (this.random.nextInt(4) != 0) continue;
                Field.field[i][j] = new Hexagon(i, j, BASES[this.random.nextInt(Options.difficulty + 1)], this.random.nextInt(2));
            }
        }
        if (Options.difficulty == 0) {
            Field.field[2][2] = new HexBlockade(2, 2);
        }
        int x = this.random.nextInt(5);
        int y = this.random.nextInt(MAX[x]);
        if (x != 2 || y != 2) {
            Field.field[x][y] = new Hexagon(x, y, BASES[this.random.nextInt(Options.difficulty + 1)], this.random.nextInt(2));
        }
        nextField = field;
        this.updateScore();
    }

    public void notifyAdjacentHexes(int x, int y) {
        this.notifyHex(x, y - 1);
        this.notifyHex(x, y + 1);
        this.notifyHex(x - 1, y);
        if (x > 2) {
            this.notifyHex(x - 1, y + 1);
        } else {
            this.notifyHex(x - 1, y - 1);
        }
        this.notifyHex(x + 1, y);
        if (x < 2) {
            this.notifyHex(x + 1, y + 1);
        } else {
            this.notifyHex(x + 1, y - 1);
        }
    }

    public void notifyHex(int x, int y) {
        try {
            Hexagon h = field[x][y];
            if (h != null) {
                h.mergeNearby();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void powerupTurn3to6() {
        for (int i = 0; i < 5; ++i) {
            for (Hexagon h : field[i]) {
                if (h == null || h.getExponent() != 0) continue;
                h.setExponent(1);
            }
        }
    }

    public void powerupErase3s() {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < MAX[i]; ++j) {
                Hexagon h = field[i][j];
                if (h == null || h.getExponent() != 0) continue;
                Field.field[i][j] = null;
            }
        }
    }

    public void powerupCombineFreePairs() {
        for (int it = 0; it < 5; ++it) {
            for (int i = 0; i < 5; ++i) {
                for (Hexagon h : field[i]) {
                    if (h == null) continue;
                    this.tryToMergeHex(h);
                }
            }
        }
    }

    private void tryToMergeHex(Hexagon h1) {
        for (int j = 0; j < 5; ++j) {
            for (Hexagon h2 : field[j]) {
                if (h2 == null || h2 == h1 || !h1.canMerge(h2) || !h2.canMerge(h1)) continue;
                h1.doubleHex();
                Field.field[h2.posX][h2.posY] = null;
                Panel3k.log("Doubling " + h1.posX + " " + h1.posY + ", Deleting " + h2.posX + " " + h2.posY);
                return;
            }
        }
    }

    public void powerupDouble(int count) {
        int i;
        ArrayList<Hexagon> hexes = new ArrayList<Hexagon>();
        for (i = 0; i < 5; ++i) {
            for (Hexagon h : field[i]) {
                if (h == null) continue;
                hexes.add(h);
            }
        }
        if (hexes.size() < count) {
            count = hexes.size();
        }
        for (i = 0; i < count; ++i) {
            if (hexes.size() <= 0) continue;
            int index = this.random.nextInt(hexes.size());
            ((Hexagon)hexes.get(index)).doubleHex();
            hexes.remove(index);
        }
    }

    public void powerupIncreaseBases() {
        for (int i = 0; i < 5; ++i) {
            block6: for (Hexagon h : field[i]) {
                if (h == null) continue;
                switch (h.getBase()) {
                    case 5: {
                        if (Options.difficulty <= 2) continue block6;
                        h.setBase(7);
                        continue block6;
                    }
                    case 3: {
                        if (Options.difficulty <= 1) continue block6;
                        h.setBase(5);
                        continue block6;
                    }
                    case 2: {
                        h.setBase(3);
                    }
                }
            }
        }
    }

    public void writeSaveFile(PrintWriter writer) {
        String s = "";
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                Hexagon h = field[i][j];
                if (h != null) {
                    if (h instanceof HexSpecial) {
                        if (h instanceof HexBlockade) {
                            s = s + "/blockade";
                            continue;
                        }
                        s = s + "/powerup," + ((HexPowerup)h).type + "," + ((HexPowerup)h).duration + "," + h.generation;
                        continue;
                    }
                    s = s + "/" + h.getBase() + "," + h.getExponent() + "," + h.generation;
                    continue;
                }
                s = s + "/";
            }
        }
        s = s + "/" + moveNumber;
        writer.println(s);
        Panel3k.log("[SAVE] Successfully wrote field!");
    }

    public void readSaveFile(String s) {
        try {
            String[] data = s.split("/", -1);
            field = new Hexagon[5][5];
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    Hexagon h;
                    String str = data[1 + 5 * i + j];
                    Panel3k.log("[SAVE] " + str);
                    if (str.length() <= 0) continue;
                    String[] hexData = str.split(",");
                    if (hexData[0].equals("blockade")) {
                        h = new HexBlockade(i, j);
                    } else if (hexData[0].equals("powerup")) {
                        h = new HexPowerup(i, j, Integer.parseInt(hexData[1]), Integer.parseInt(hexData[2]));
                        h.generation = Integer.parseInt(hexData[3]);
                    } else {
                        h = new Hexagon(i, j, Integer.parseInt(hexData[0]), Integer.parseInt(hexData[1]));
                        h.generation = Integer.parseInt(hexData[2]);
                    }
                    Field.field[i][j] = h;
                }
            }
            moveNumber = Integer.parseInt(data[data.length - 1]);
            nextField = field;
            this.updateScore();
            if (!this.canMakeAnotherMove()) {
                Panel3k.popups.popup(2);
            }
            Panel3k.log("[SAVE] Successfully read field!");
        }
        catch (Exception e) {
            Panel3k.log("[SAVE] Error reading field!");
            e.printStackTrace();
        }
    }

    public boolean canMakeAnotherMove() {
        for (int i = 0; i < 5; ++i) {
            for (Hexagon h : field[i]) {
                if (h == null) continue;
                Panel3k.log("Can move? Hex " + h.getDisplayedString() + " at " + h.posX + ", " + h.posY);
                if (!h.canMove()) continue;
                return true;
            }
        }
        return false;
    }

    static {
        OFFSET = new float[]{1.0f, 0.5f, 0.0f, 0.5f, 1.0f};
        MAX = new int[]{3, 4, 5, 4, 3};
        BASES = new int[]{3, 2, 5, 7};
        moveTick = 0.0f;
        currentDir = -1;
        moveTimes = 0;
        score = 0L;
        moveNumber = 0L;
    }
}

