/*
 * Decompiled with CFR 0.152.
 */
package com.juliand665;

import com.juliand665.Field;
import com.juliand665.HexSpecial;
import com.juliand665.LoggingLevel;
import com.juliand665.Panel3k;
import com.juliand665.Resources;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class HexPowerup
extends HexSpecial {
    public int type;
    public int duration;
    public static int descToRender = -1;
    private boolean mouseOver = false;

    public HexPowerup(int x, int y, int powerupType, int dur) {
        super(x, y);
        this.type = powerupType;
        this.duration = dur;
    }

    @Override
    public void drawHex(Graphics g) {
        g.drawImage(Resources.powerupTiles[this.type], this.x - 64, this.y - 64, null);
        if (this.duration > 0) {
            g.drawString(this.duration + "x", this.x + 6, this.y - 16);
        }
        if (this.flash > 0.0f) {
            Graphics2D gr = (Graphics2D)g.create();
            gr.setComposite(AlphaComposite.getInstance(3, this.flash / 128.0f));
            gr.drawImage(Resources.particles[1], this.x - 64, this.y - 64, null);
            this.flash -= (float)Panel3k.renderer.getSPF();
        }
    }

    @Override
    public void mergeNearby() {
        int x = 372 + this.posX * 98;
        int y = (int)(96.0f + ((float)this.posY + Field.OFFSET[this.posX]) * 112.0f);
        Panel3k.log("Generation " + this.generation + " powerup " + this.type + " has been notified! " + x + " " + y);
        if (this.generation == 0) {
            return;
        }
        Panel3k.particleManager.createRandomizedParticlesAt(x, y, 16);
        if (this.mouseOver) {
            this.mouseOver = false;
            descToRender = -1;
        }
        switch (this.type) {
            case 0: {
                Panel3k.activePowerups[0] = Panel3k.activePowerups[0] + this.duration;
                break;
            }
            case 1: {
                Panel3k.activePowerups[1] = Panel3k.activePowerups[1] + this.duration;
                break;
            }
            case 2: {
                Panel3k.activePowerups[2] = Panel3k.activePowerups[2] + this.duration;
                break;
            }
            case 3: {
                Panel3k.field.powerupTurn3to6();
                break;
            }
            case 4: {
                Panel3k.field.powerupErase3s();
                break;
            }
            case 5: {
                Panel3k.field.powerupCombineFreePairs();
                break;
            }
            case 6: {
                Panel3k.field.powerupDouble(this.duration);
                break;
            }
            case 7: {
                Panel3k.field.powerupIncreaseBases();
            }
        }
        Field.field[this.posX][this.posY] = null;
        Panel3k.field.updateScore();
    }

    public void mouseMoved(MouseEvent e) {
        Point point = new Point(this.x, this.y);
        if (e.getPoint().distance(point) < 64.0 && Field.moveTick <= 0.0f) {
            descToRender = this.type;
            if (!this.mouseOver) {
                this.mouseOver = true;
            }
        } else if (this.mouseOver) {
            this.mouseOver = false;
            descToRender = -1;
        }
    }

    @Override
    public void move(int dir) {
        if (this.mouseOver) {
            this.mouseOver = false;
            descToRender = -1;
        }
        this.startX = this.posX;
        this.startY = this.posY;
        this.targetX = this.posX;
        this.targetY = this.posY;
        try {
            switch (dir) {
                case 0: {
                    if (this.startY <= 0 || Field.nextField[this.startX][this.startY - 1] != null) break;
                    this.targetY = this.startY - 1;
                    break;
                }
                case 1: {
                    if (this.startX >= 4 || this.startY <= (this.startX < 2 ? -1 : 0) || Field.nextField[this.startX + 1][this.startY - (this.startX < 2 ? 0 : 1)] != null) break;
                    this.targetY = this.startY - (this.startX < 2 ? 0 : 1);
                    this.targetX = this.startX + 1;
                    break;
                }
                case 2: {
                    int yd;
                    if (this.startX >= 4 || this.startX >= 2 && this.startY >= Field.MAX[this.startX] - 1) break;
                    int n = yd = this.startX < 2 ? 1 : 0;
                    if (Field.nextField[this.startX + 1][this.startY + yd] != null) break;
                    this.targetY = this.startY + yd;
                    this.targetX = this.startX + 1;
                    break;
                }
                case 3: {
                    if (this.startY >= Field.MAX[this.startX] - 1 || Field.nextField[this.startX][this.startY + 1] != null) break;
                    this.targetY = this.startY + 1;
                    break;
                }
                case 4: {
                    int yd;
                    if (this.startX <= 0 || this.startX <= 2 && this.startY >= Field.MAX[this.startX] - 1) break;
                    int n = yd = this.startX > 2 ? 1 : 0;
                    if (Field.nextField[this.startX - 1][this.startY + yd] != null) break;
                    this.targetY = this.startY + yd;
                    this.targetX = this.startX - 1;
                    break;
                }
                case 5: {
                    if (this.startX <= 0 || this.startY <= (this.startX > 2 ? -1 : 0) || Field.nextField[this.startX - 1][this.startY - (this.startX > 2 ? 0 : 1)] != null) break;
                    this.targetY = this.startY - (this.startX > 2 ? 0 : 1);
                    this.targetX = this.startX - 1;
                }
            }
            HexPowerup h = new HexPowerup(this.targetX, this.targetY, this.type, this.duration);
            if (this.startX != this.targetX || this.startY != this.targetY) {
                Panel3k.log("Generation " + this.generation + " POWERUP hex " + this.type + " moved. X: " + this.startX + "=>" + this.targetX + ", Y: " + this.startY + "=>" + this.targetY);
                if (this.hasMerged) {
                    this.checkIfHighestHex();
                }
                this.hasMoved = true;
            }
            h.hasMoved = this.hasMoved;
            h.generation = this.generation + 1;
            Field.nextField[this.targetX][this.targetY] = h;
        }
        catch (Exception e) {
            e.printStackTrace();
            Panel3k.log(LoggingLevel.ERROR, "Exception caused! Generation " + this.generation + " POWERUP hex " + this.type + " moved. X: " + this.startX + "=>" + this.targetX + ", Y: " + this.startY + "=>" + this.targetY + ", dir: " + dir);
        }
    }

    public void setDuration(int i) {
        this.duration = i;
    }
}

