/*
 * Decompiled with CFR 0.152.
 */
package com.juliand665;

import com.juliand665.Field;
import com.juliand665.LoggingLevel;
import com.juliand665.Options;
import com.juliand665.Panel3k;
import com.juliand665.Resources;
import java.awt.AlphaComposite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;

public class Hexagon {
    protected Field field;
    protected int base;
    protected int exponent;
    protected double number;
    public int posX;
    public int posY;
    public int startX;
    public int startY;
    public int targetX;
    public int targetY;
    public int x;
    public int y;
    public boolean hasMerged;
    public boolean hasMoved;
    public static final String[] SUFFIXES = new String[]{"", "k", "m", "b", "t", "q"};
    public static Map<Integer, Integer> baseToOffset;
    public int generation = 0;
    public float flash = 0.0f;

    public Hexagon(int x, int y, int base, int exponent) {
        this(x, y, base, exponent, x, y, x, y);
    }

    public Hexagon(int x, int y, int base, int exponent, int sx, int sy, int tx, int ty) {
        this.posX = x;
        this.posY = y;
        this.x = 372 + this.posX * 98;
        this.y = (int)(96.0f + ((float)this.posY + Field.OFFSET[this.posX]) * 112.0f);
        this.base = base;
        this.exponent = exponent;
        this.number = base * (int)Math.pow(2.0, exponent);
        this.field = Panel3k.field;
        this.startX = sx;
        this.startY = sy;
        this.targetX = tx;
        this.targetY = ty;
        if (baseToOffset == null) {
            baseToOffset = new HashMap<Integer, Integer>();
            baseToOffset.put(3, 0);
            baseToOffset.put(2, 9);
            baseToOffset.put(5, 18);
            baseToOffset.put(7, 27);
        }
        this.checkIfHighestHex();
    }

    public void checkIfHighestHex() {
        if (this.getNumber() > 1.0 * (double)Panel3k.highestTile[Options.difficulty][0] * Math.pow(2.0, Panel3k.highestTile[Options.difficulty][1])) {
            Panel3k.highestTile[Options.difficulty][0] = this.base;
            Panel3k.highestTile[Options.difficulty][1] = this.exponent;
        }
    }

    public void render(Graphics g) {
        if (Field.moveTick != 0.0f) {
            this.x = 372 + this.targetX * 98;
            this.y = (int)(96.0f + ((float)this.targetY + Field.OFFSET[this.targetX]) * 112.0f);
            int x2 = 372 + this.startX * 98;
            int y2 = (int)(96.0f + ((float)this.startY + Field.OFFSET[this.posX]) * 112.0f);
            this.x = (int)((double)this.x + 1.0 * (double)(x2 - this.x) * (double)Field.moveTick / 50.0);
            this.y = (int)((double)this.y + 1.0 * (double)(y2 - this.y) * (double)Field.moveTick / 50.0);
            this.drawHex(g);
        } else {
            this.startX = this.posX;
            this.startY = this.posY;
            this.x = 372 + this.posX * 98;
            this.y = (int)(96.0f + ((float)this.posY + Field.OFFSET[this.posX]) * 112.0f);
            this.drawHex(g);
        }
    }

    public void drawHex(Graphics g) {
        g.drawImage(Resources.smallHexes[(this.exponent % 10 + baseToOffset.get(this.base)) % 36], this.x - 64, this.y - 64, null);
        if (this.exponent > 9 && this.exponent < 60) {
            g.drawImage(Resources.overlays[(this.exponent > 39 ? 39 : this.exponent) / 10 - 1], this.x - 64, this.y - 64, null);
        }
        if (Options.flashHexes && this.flash > 0.0f) {
            Graphics2D gr = (Graphics2D)g.create();
            gr.setComposite(AlphaComposite.getInstance(3, this.flash / 128.0f));
            gr.drawImage(Resources.particles[1], this.x - 64, this.y - 64, null);
            this.flash -= (float)Panel3k.renderer.getSPF() / 2.0f;
        }
        String s = this.getDisplayedString();
        this.drawStringCenteredOnHex(g, s);
    }

    public void drawStringCenteredOnHex(Graphics g, String s) {
        FontMetrics fm = g.getFontMetrics();
        int width = (int)fm.getStringBounds(s, 0, s.length(), g).getWidth();
        int height = fm.getHeight() * 3 / 5;
        g.drawString(s, this.x - width / 2, this.y + height / 2);
    }

    public int getBase() {
        return this.base;
    }

    public void setBase(int b) {
        this.base = b;
        this.number = this.base * (int)Math.pow(2.0, this.exponent);
        this.flash = 96.0f;
        this.checkIfHighestHex();
    }

    public int getExponent() {
        return this.exponent;
    }

    public void setExponent(int e) {
        this.exponent = e;
        this.number = this.base * (int)Math.pow(2.0, this.exponent);
        this.flash = 96.0f;
        this.checkIfHighestHex();
    }

    public double getNumber() {
        this.number = (double)this.base * Math.pow(2.0, this.exponent);
        return this.number;
    }

    public boolean canMove() {
        if (this.posY > 0 && (Field.field[this.posX][this.posY - 1] == null || this.canMerge(Field.field[this.posX][this.posY - 1]))) {
            return true;
        }
        if (this.posX < 4 && this.posY > (this.posX < 2 ? -1 : 0) && (Field.field[this.posX + 1][this.posY - (this.posX < 2 ? 0 : 1)] == null || this.canMerge(Field.field[this.posX + 1][this.posY - (this.posX < 2 ? 0 : 1)]))) {
            return true;
        }
        if (!(this.posX >= 4 || this.posX >= 2 && this.posY >= Field.MAX[this.posX] - 1 || Field.field[this.posX + 1][this.posY + (this.posX < 2 ? 1 : 0)] != null && !this.canMerge(Field.field[this.posX + 1][this.posY + (this.posX < 2 ? 1 : 0)]))) {
            return true;
        }
        if (this.posY < Field.MAX[this.posX] - 1 && (Field.field[this.posX][this.posY + 1] == null || this.canMerge(Field.field[this.posX][this.posY + 1]))) {
            return true;
        }
        if (!(this.posX <= 0 || this.posX <= 2 && this.posY >= Field.MAX[this.posX] - 1 || Field.field[this.posX - 1][this.posY + (this.posX > 2 ? 1 : 0)] != null && !this.canMerge(Field.field[this.posX - 1][this.posY + (this.posX > 2 ? 1 : 0)]))) {
            return true;
        }
        return this.posX > 0 && this.posY < (this.posX > 2 ? -1 : 0) && (Field.field[this.posX - 1][this.posY - (this.posX > 2 ? 0 : 1)] == null || this.canMerge(Field.field[this.posX - 1][this.posY - (this.posX > 2 ? 0 : 1)]));
    }

    public void move(int dir) {
        this.startX = this.posX;
        this.startY = this.posY;
        this.targetX = this.posX;
        this.targetY = this.posY;
        try {
            switch (dir) {
                case 0: {
                    if (this.startY <= 0) break;
                    if (Field.nextField[this.startX][this.startY - 1] == null) {
                        this.targetY = this.startY - 1;
                        break;
                    }
                    Hexagon hex = Field.nextField[this.startX][this.startY - 1];
                    if (!this.canMerge(hex)) break;
                    this.doubleHex();
                    if (Panel3k.activePowerups[0] > 0) {
                        this.doubleHex();
                    }
                    this.targetY = this.startY - 1;
                    this.hasMerged = true;
                    break;
                }
                case 1: {
                    if (this.startX >= 4 || this.startY <= (this.startX < 2 ? -1 : 0)) break;
                    if (Field.nextField[this.startX + 1][this.startY - (this.startX < 2 ? 0 : 1)] == null) {
                        this.targetY = this.startY - (this.startX < 2 ? 0 : 1);
                        this.targetX = this.startX + 1;
                        break;
                    }
                    Hexagon hex = Field.nextField[this.startX + 1][this.startY - (this.startX < 2 ? 0 : 1)];
                    if (!this.canMerge(hex)) break;
                    this.doubleHex();
                    if (Panel3k.activePowerups[0] > 0) {
                        this.doubleHex();
                    }
                    this.targetY = this.startY - (this.startX < 2 ? 0 : 1);
                    this.targetX = this.startX + 1;
                    this.hasMerged = true;
                    break;
                }
                case 2: {
                    int yd;
                    if (this.startX >= 4 || this.startX >= 2 && this.startY >= Field.MAX[this.startX] - 1) break;
                    int n = yd = this.startX < 2 ? 1 : 0;
                    if (Field.nextField[this.startX + 1][this.startY + yd] == null) {
                        this.targetY = this.startY + yd;
                        this.targetX = this.startX + 1;
                        break;
                    }
                    Hexagon hex = Field.nextField[this.startX + 1][this.startY + yd];
                    if (!this.canMerge(hex)) break;
                    this.doubleHex();
                    if (Panel3k.activePowerups[0] > 0) {
                        this.doubleHex();
                    }
                    this.targetY = this.startY + yd;
                    this.targetX = this.startX + 1;
                    this.hasMerged = true;
                    break;
                }
                case 3: {
                    if (this.startY >= Field.MAX[this.startX] - 1) break;
                    if (Field.nextField[this.startX][this.startY + 1] == null) {
                        this.targetY = this.startY + 1;
                        break;
                    }
                    Hexagon hex = Field.nextField[this.startX][this.startY + 1];
                    if (!this.canMerge(hex)) break;
                    this.doubleHex();
                    if (Panel3k.activePowerups[0] > 0) {
                        this.doubleHex();
                    }
                    this.targetY = this.startY + 1;
                    this.hasMerged = true;
                    break;
                }
                case 4: {
                    int yd;
                    if (this.startX <= 0 || this.startX <= 2 && this.startY >= Field.MAX[this.startX] - 1) break;
                    int n = yd = this.startX > 2 ? 1 : 0;
                    if (Field.nextField[this.startX - 1][this.startY + yd] == null) {
                        this.targetY = this.startY + yd;
                        this.targetX = this.startX - 1;
                        break;
                    }
                    Hexagon hex = Field.nextField[this.startX - 1][this.startY + yd];
                    if (!this.canMerge(hex)) break;
                    this.doubleHex();
                    if (Panel3k.activePowerups[0] > 0) {
                        this.doubleHex();
                    }
                    this.targetY = this.startY + yd;
                    this.targetX = this.startX - 1;
                    this.hasMerged = true;
                    break;
                }
                case 5: {
                    if (this.startX <= 0 || this.startY <= (this.startX > 2 ? -1 : 0)) break;
                    if (Field.nextField[this.startX - 1][this.startY - (this.startX > 2 ? 0 : 1)] == null) {
                        this.targetY = this.startY - (this.startX > 2 ? 0 : 1);
                        this.targetX = this.startX - 1;
                        break;
                    }
                    Hexagon hex = Field.nextField[this.startX - 1][this.startY - (this.startX > 2 ? 0 : 1)];
                    if (!this.canMerge(hex)) break;
                    this.doubleHex();
                    if (Panel3k.activePowerups[0] > 0) {
                        this.doubleHex();
                    }
                    this.targetY = this.startY - (this.startX > 2 ? 0 : 1);
                    this.targetX = this.startX - 1;
                    this.hasMerged = true;
                }
            }
            Hexagon h = new Hexagon(this.targetX, this.targetY, this.base, this.exponent, this.startX, this.startY, this.targetX, this.targetY);
            if (this.startX != this.targetX || this.startY != this.targetY) {
                Panel3k.log("Generation " + this.generation + " hex " + this.getDisplayedString() + " moved. X: " + this.startX + "=>" + this.targetX + ", Y: " + this.startY + "=>" + this.targetY);
                if (this.hasMerged) {
                    this.checkIfHighestHex();
                }
                this.hasMoved = true;
            }
            h.hasMoved = this.hasMoved;
            h.hasMerged = this.hasMerged;
            h.generation = this.generation + 1;
            h.flash = this.flash;
            Field.nextField[this.targetX][this.targetY] = h;
        }
        catch (Exception e) {
            e.printStackTrace();
            Panel3k.log(LoggingLevel.ERROR, "Exception caused! Hex " + this.getDisplayedString() + " moved. X: " + this.startX + "=>" + this.targetX + ", Y: " + this.startY + "=>" + this.targetY + ", dir: " + dir);
        }
    }

    public void doubleHex() {
        this.setExponent(this.exponent + 1);
        this.flash = 96.0f;
    }

    public boolean canMerge(Hexagon hex) {
        return hex.getNumber() == this.number && !this.hasMerged && !hex.hasMerged;
    }

    public void doneMoving() {
        if (this.hasMerged) {
            this.field.notifyAdjacentHexes(this.posX, this.posY);
        }
        this.hasMerged = false;
        this.hasMoved = false;
    }

    public void resetMoveVars() {
    }

    public static String getDisplayedString(int b, int e) {
        return (int)((double)b * Math.pow(2.0, e % 10)) + SUFFIXES[e / 10];
    }

    public String getDisplayedString() {
        return Hexagon.getDisplayedString(this.base, this.exponent);
    }

    public void mergeNearby() {
    }
}

