/*
 * Decompiled with CFR 0.152.
 */
package com.juliand665;

import com.juliand665.Options;
import com.juliand665.Panel3k;
import com.juliand665.Resources;
import com.juliand665.Screen;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class Instructions {
    public static int currentScreen = 0;
    public static final Rectangle[] buttons = new Rectangle[]{new Rectangle(176, 511, 128, 128), new Rectangle(832, 511, 128, 128)};
    public static final int[] POWERUP_X_BOUNDS = new int[]{8, 136, 144, 272, 280, 408, 456, 584, 592, 720, 728, 856, 864, 992, 1000, 1128};
    private int mouseOver = -1;

    public void mouseMoved(int x, int y) {
        if (currentScreen == 3 && y >= 160 && y < 288) {
            for (int i = 0; i < 8; ++i) {
                if (x <= POWERUP_X_BOUNDS[i * 2] || x >= POWERUP_X_BOUNDS[i * 2 + 1]) continue;
                this.mouseOver = i + 2;
            }
        } else {
            this.mouseOver = -1;
            for (int i = 0; i < 2; ++i) {
                if (!buttons[i].contains(x, y)) continue;
                this.mouseOver = i;
            }
        }
    }

    public void mouseReleased(int x, int y) {
        if (this.mouseOver == 0 && currentScreen > 0) {
            --currentScreen;
        }
        if (this.mouseOver == 1 && currentScreen < 3) {
            ++currentScreen;
        }
    }

    public void render(Graphics2D g) {
        int i;
        g.drawImage(Resources.instructionsBg[currentScreen], 0, 0, null);
        Panel3k.menuButton.render(g);
        g.setColor(Color.WHITE);
        g.setFont(Resources.baseFont.deriveFont(64.0f));
        for (i = 0; i < 2; ++i) {
            if (currentScreen == 0 && i == 0 || currentScreen == 3 && i == 1) continue;
            if (this.mouseOver == i) {
                g.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            g.drawImage(Resources.smallHexes[Panel3k.highestTile[Options.difficulty][1] % 10], Instructions.buttons[i].x, Instructions.buttons[i].y, null);
            Panel3k.renderer.drawStringCentered(g, i == 0 ? "<" : ">", Instructions.buttons[i].x + 64, Instructions.buttons[i].y + 58);
            g.setComposite(AlphaComposite.getInstance(3));
        }
        if (currentScreen == 3) {
            for (i = 0; i < 8; ++i) {
                g.drawImage(Resources.powerupTiles[i], POWERUP_X_BOUNDS[i * 2], 160, null);
            }
            if (this.mouseOver > 1) {
                g.setComposite(AlphaComposite.getInstance(3, 0.5f));
                g.setColor(new Color(14804714));
                g.fillRect(0, 0, 1136, 640);
                g.setComposite(AlphaComposite.getInstance(3));
                g.drawImage(Resources.powerupDescs[this.mouseOver - 2], 184, 352, null);
                g.drawImage(Resources.powerupTiles[this.mouseOver - 2], POWERUP_X_BOUNDS[(this.mouseOver - 2) * 2], 160, null);
            }
        }
    }

    public void switchTo() {
        Panel3k.currentScreen = Screen.INSTRUCTIONS;
        Panel3k.menuButton.setPos(90, 20);
    }
}

