/*
 * Decompiled with CFR 0.152.
 */
package com.juliand665;

import com.juliand665.Panel3k;
import com.juliand665.Resources;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;

public class Popups {
    private int[] states = new int[]{0, 0, 0};
    private Rectangle[] bounds = new Rectangle[3];
    private int mouseOver;

    public Popups() {
        this.bounds[0] = new Rectangle(272, 40, 592, 112);
        this.bounds[1] = new Rectangle(272, 488, 592, 112);
        this.bounds[2] = new Rectangle(272, 264, 592, 112);
    }

    public void render(Graphics2D g) {
        for (int i = 0; i < 3; ++i) {
            if (this.states[i] != 1) continue;
            g.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g.setColor(new Color(14804714));
            g.fillRect(0, 0, 1136, 640);
            g.setComposite(AlphaComposite.getInstance(3));
            if (this.mouseOver == i) {
                g.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            g.drawImage(Resources.popups[i], this.bounds[i].x, this.bounds[i].y, null);
            g.setComposite(AlphaComposite.getInstance(3));
        }
    }

    public void reset() {
        this.states[0] = 0;
        this.states[1] = 0;
    }

    public void mouseMoved(MouseEvent e) {
        for (int i = 0; i < 3; ++i) {
            if (!this.bounds[i].contains(e.getPoint())) continue;
            this.mouseOver = i;
            return;
        }
        this.mouseOver = -1;
    }

    public void mouseClicked() {
        if (this.mouseOver == 2) {
            this.states[this.mouseOver] = 0;
        } else if (this.mouseOver > -1) {
            this.states[this.mouseOver] = -1;
        }
    }

    public void popup(int i) {
        Panel3k.log("Popping up popup " + i);
        if (this.states[i] == 0) {
            this.states[i] = 1;
        }
    }

    public void writeSaveFile(PrintWriter writer) {
        writer.println(this.states[0] + "/" + this.states[1]);
    }

    public void readSaveFile(String s) {
        String[] data = s.split("/");
        this.states[0] = Integer.parseInt(data[0]);
        this.states[1] = Integer.parseInt(data[1]);
    }
}

